#include <stdio.h>
#include <string.h>
#include <limits.h>

int main() {
    int N;
    if (scanf("%d", &N) != 1) return 0;
    char s[N+5];
    if (scanf("%s", s) != 1) return 0;

    int pos = -1;
    for (int i = 0; i < N; ++i) if (s[i] == '+') { pos = i; break; }

    int best = INT_MAX;
    for (int i = 0; i < N; ++i) {
        if (s[i] == '#') {
            int diff = (i - pos) % N;
            if (diff < 0) diff += N;
            int d1 = diff;                 // clockwise distance from pos to i
            int d2 = N - diff;             // counter-clockwise distance
            int d = d1 < d2 ? d1 : d2;
            if (d < best) best = d;
        }
    }

    // According to statement, there's at least one '#', so best is set.
    printf("%d\n", best);
    return 0;
}